class Monsters extends ScriptedPawn;

var int LifeTime;

replication
{
	// Variables the server should send to the client.
	reliable if( Role==ROLE_Authority )
		LifeTime;
}

function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.IsA('ScriptedPawn') )
		return ATTITUDE_Friendly;
	else if ( Other.IsA('PlayerPawn') || Other.IsA('Bot'))
		{
		if ( Other.IsA('PlayerPawn') && PlayerPawn(Other).PlayerReplicationInfo.bIsSpectator)
			{
			return ATTITUDE_Ignore;
			}
		else
			{
			return ATTITUDE_Hate;
			}
		}
	else
		return ATTITUDE_Ignore;
}

function bool SetEnemy( Pawn NewEnemy )
{
	local bool result;
	local eAttitude newAttitude, oldAttitude;
	local bool noOldEnemy;
	local float newStrength;

	if ( NewEnemy.IsA('PlayerPawn') || NewEnemy.IsA('Bot'))
		{
		if ( NewEnemy.IsA('PlayerPawn') && PlayerPawn(NewEnemy).PlayerReplicationInfo.bIsSpectator)
			{
			return false;
			}
		}

		

	else if ( NewEnemy.IsA('ScriptetPawn') )
		return false;

	noOldEnemy = (Enemy == None);
	result = false;
	newAttitude = AttitudeTo(NewEnemy);
	//log ("Attitude to potential enemy is "$newAttitude);
	if ( !noOldEnemy )
	{
		if (Enemy == NewEnemy)
			return true;
		else if ( NewEnemy.bIsPlayer && (AlarmTag != '') )
		{
			OldEnemy = Enemy;
			Enemy = NewEnemy;
			result = true;
		} 
		else if ( newAttitude == ATTITUDE_Friendly )
		{
			if ( bIgnoreFriends )
				return false;
			if ( (NewEnemy.Enemy != None) && (NewEnemy.Enemy.Health > 0) ) 
			{
				if ( NewEnemy.Enemy.bIsPlayer && (NewEnemy.AttitudeToPlayer < AttitudeToPlayer) )
					AttitudeToPlayer = NewEnemy.AttitudeToPlayer;
				if ( AttitudeTo(NewEnemy.Enemy) < AttitudeTo(Enemy) )
				{
					OldEnemy = Enemy;
					Enemy = NewEnemy.Enemy;
					result = true;
				}
			}
		}
		else 
		{
			oldAttitude = AttitudeTo(Enemy);
			if ( (newAttitude < oldAttitude) || 
				( (newAttitude == oldAttitude) 
					&& ((VSize(NewEnemy.Location - Location) < VSize(Enemy.Location - Location)) 
						|| !LineOfSightTo(Enemy)) ) ) 
			{
				if ( bIsPlayer && Enemy.IsA('PlayerPawn') && !NewEnemy.IsA('PlayerPawn') )
				{
					newStrength = relativeStrength(NewEnemy);
					if ( (newStrength < 0.2) && (relativeStrength(Enemy) < FMin(0, newStrength))  
						&& (IsInState('Hunting')) && (Level.TimeSeconds - HuntStartTime < 5) )
						result = false;
					else
					{
						result = true;
						OldEnemy = Enemy;
						Enemy = NewEnemy;
					}
				} 
				else
				{
					result = true;
					OldEnemy = Enemy;
					Enemy = NewEnemy;
				}
			}
		}
	}
	else if ( newAttitude < ATTITUDE_Ignore )
	{
		result = true;
		Enemy = NewEnemy;
	}
	else if ( newAttitude == ATTITUDE_Friendly ) //your enemy is my enemy
	{
		//log("noticed a friend");
		if ( NewEnemy.bIsPlayer && (AlarmTag != '') )
		{
			Enemy = NewEnemy;
			result = true;
		} 
		if (bIgnoreFriends)
			return false;

		if ( (NewEnemy.Enemy != None) && (NewEnemy.Enemy.Health > 0) ) 
		{
			result = true;
			//log("his enemy is my enemy");
			Enemy = NewEnemy.Enemy;
			if (Enemy.bIsPlayer)
				AttitudeToPlayer = ScriptedPawn(NewEnemy).AttitudeToPlayer;
			else if ( (ScriptedPawn(NewEnemy) != None) && (ScriptedPawn(NewEnemy).Hated == Enemy) )
				Hated = Enemy;
		}
	}

	if ( result )
	{
		//log(class$" has new enemy - "$enemy.class);
		LastSeenPos = Enemy.Location;
		LastSeeingPos = Location;
		EnemyAcquired();
		if ( !bFirstHatePlayer && Enemy.bIsPlayer && (FirstHatePlayerEvent != '') )
			{
			TriggerFirstHate();
			}
	}
	else if ( NewEnemy.bIsPlayer && (NewAttitude < ATTITUDE_Threaten) )
		OldEnemy = NewEnemy;
				
	return result;
}

defaultproperties
{
     CarcassType=Class'UnrealShare.CreatureCarcass'
     TimeBetweenAttacks=1.000000
     WalkingSpeed=0.400000
     bLeadTarget=True
     bWarnTarget=True
     bFirstShot=True
     ProjectileSpeed=800.000000
     bFixedStart=True
     AirSpeed=320.000000
     AccelRate=200.000000
     HearingThreshold=0.300000
     Land=Sound'UnrealShare.Generic.Land1'
     WaterStep=Sound'UnrealShare.Generic.LSplash'
     AmbientGlow=15
     LifeTime=0
}
